﻿using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Controls
{
    public partial class ViewPatient : BaseControl
    {
        public bool ShowViewDetails
        {
            get { return linkViewDetails.Visible; }
            set { linkViewDetails.Visible = value; }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            //No need to log PAGE_LOAD here as the control will be available on .ASPX pages

            try
            {
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        public void LoadForm(int id)
        {
            ResetForm();

            PATIENT patient = ServiceInterfaceManager.PATIENT_GET_COMPLETE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, id);
            if (patient != null)
            {
                lblLastName.Text = AntiXssEnc.Encoder.HtmlEncode(patient.LAST_NAME);
                lblFirstName.Text = AntiXssEnc.Encoder.HtmlEncode(patient.FIRST_NAME);

                if (patient.BIRTH_DATE != null)
                    lblDateOfBirth.Text = AntiXssEnc.Encoder.HtmlEncode(patient.BIRTH_DATE.Value.ToString("MM/dd/yyyy"));

                if (patient.OEFOIF_IND != null)
                    lblOefOif.Text = AntiXssEnc.Encoder.HtmlEncode((patient.OEFOIF_IND.Value) ? "Yes" : "No");

                if (patient.SPATIENT != null)
                {
                    lblLastFour.Text = AntiXssEnc.Encoder.HtmlEncode(patient.SPATIENT.PatientLastFour);
                    if (patient.SPATIENT.LastServiceSeparationDate != null)
                        lblServiceSeparation.Text = AntiXssEnc.Encoder.HtmlEncode(patient.SPATIENT.LastServiceSeparationDate.Value.ToString("MM/dd/yyyy"));
                }

                lblMultiRaceIndicator.Text = (patient.MULTI_RACE_INDICATOR ? "Y" : "N");
                lblMultiEthnicityIndicator.Text = (patient.MULTI_ETHNICITY_INDICATOR ? "Y" : "N");
            }
            else
                linkViewDetails.Visible = false;
        }

        public void ResetForm()
        {
            lblLastName.Text = string.Empty;
            lblFirstName.Text = string.Empty;
            lblDateOfBirth.Text = string.Empty;
            lblLastFour.Text = string.Empty;
            lblOefOif.Text = string.Empty;
            lblServiceSeparation.Text = string.Empty;
            lblMultiRaceIndicator.Text = string.Empty;
            lblMultiEthnicityIndicator.Text = string.Empty;
        }
    }
}